/*
 * Decompiled with CFR 0.152.
 */
package net.ftb.gui;

import com.google.common.eventbus.EventBus;
import com.google.common.eventbus.Subscribe;
import java.awt.AWTException;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.SystemTray;
import java.awt.Toolkit;
import java.awt.TrayIcon;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutionException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.ftb.data.LauncherStyle;
import net.ftb.data.LoginResponse;
import net.ftb.data.Map;
import net.ftb.data.ModPack;
import net.ftb.data.Settings;
import net.ftb.data.TexturePack;
import net.ftb.data.UserManager;
import net.ftb.events.EnableObjectsEvent;
import net.ftb.gui.ImageAndTextIcon;
import net.ftb.gui.LaunchFrameHelpers;
import net.ftb.gui.LauncherConsole;
import net.ftb.gui.TrayMenu;
import net.ftb.gui.dialogs.FirstRunDialog;
import net.ftb.gui.dialogs.LauncherUpdateDialog;
import net.ftb.gui.dialogs.LoadingDialog;
import net.ftb.gui.dialogs.ModPackVersionChangeDialog;
import net.ftb.gui.dialogs.PasswordDialog;
import net.ftb.gui.dialogs.PlayOfflineDialog;
import net.ftb.gui.dialogs.ProfileAdderDialog;
import net.ftb.gui.dialogs.ProfileEditorDialog;
import net.ftb.gui.panes.FTBPacksPane;
import net.ftb.gui.panes.ILauncherPane;
import net.ftb.gui.panes.MapUtils;
import net.ftb.gui.panes.NewsPane;
import net.ftb.gui.panes.OptionsPane;
import net.ftb.gui.panes.TexturepackPane;
import net.ftb.gui.panes.ThirdPartyPane;
import net.ftb.locale.I18N;
import net.ftb.log.LogLevel;
import net.ftb.log.LogSource;
import net.ftb.log.LogWriter;
import net.ftb.log.Logger;
import net.ftb.log.OutputOverride;
import net.ftb.log.StdOutLogger;
import net.ftb.minecraft.MCInstaller;
import net.ftb.tools.MapManager;
import net.ftb.tools.ModManager;
import net.ftb.tools.ProcessMonitor;
import net.ftb.tools.TextureManager;
import net.ftb.tracking.google.AnalyticsConfigData;
import net.ftb.tracking.google.JGoogleAnalyticsTracker;
import net.ftb.updater.UpdateChecker;
import net.ftb.util.AppUtils;
import net.ftb.util.Benchmark;
import net.ftb.util.CheckInstallPath;
import net.ftb.util.DownloadUtils;
import net.ftb.util.ErrorUtils;
import net.ftb.util.FileUtils;
import net.ftb.util.OSUtils;
import net.ftb.util.ObjectUtils;
import net.ftb.util.StyleUtil;
import net.ftb.util.TrackerUtils;
import net.ftb.util.winreg.JavaInfo;
import net.ftb.workers.AuthlibDLWorker;
import net.ftb.workers.LoginWorker;
import net.ftb.workers.UnreadNewsWorker;

public class LaunchFrame
extends JFrame {
    private LoginResponse RESPONSE;
    private NewsPane newsPane;
    public static JPanel panel;
    private JPanel footer = new JPanel();
    private JLabel footerLogo = new JLabel(new ImageIcon(this.getClass().getResource("/image/logo_ftb.png")));
    private JLabel footerCreeper = new JLabel(new ImageIcon(this.getClass().getResource("/image/logo_creeperHost.png")));
    private JLabel tpInstallLocLbl = new JLabel();
    private final JButton launch = new JButton();
    private final JButton edit = new JButton();
    private final JButton donate = new JButton();
    private final JButton serverbutton = new JButton();
    private final JButton mapInstall = new JButton();
    private final JButton serverMap = new JButton();
    private final JButton tpInstall = new JButton();
    private static String[] dropdown_;
    private static JComboBox users;
    private static JComboBox tpInstallLocation;
    private static JComboBox mapInstallLocation;
    private static LaunchFrame instance;
    public static boolean canUseAuthlib;
    public static int minUsable;
    public final JTabbedPane tabbedPane = new JTabbedPane(1);
    protected static UserManager userManager;
    public FTBPacksPane modPacksPane;
    public ThirdPartyPane thirdPartyPane;
    public MapUtils mapsPane;
    public TexturepackPane tpPane;
    public OptionsPane optionsPane;
    public static TrayMenu trayMenu;
    public static boolean noConfig;
    public static boolean allowVersionChange;
    public static boolean doVersionBackup;
    public static boolean MCRunning;
    public static boolean i18nLoaded;
    public static LauncherConsole con;
    public static String tempPass;
    public static Panes currentPane;
    public static AnalyticsConfigData AnalyticsConfigData;
    public static JGoogleAnalyticsTracker tracker;
    public static LoadingDialog loader;
    private static ProcessMonitor procMonitor;
    private EventBus eventBus = new EventBus();
    private boolean tpEnabled = true;

    public static void main(String[] args) {
        block11: {
            Benchmark.start("main");
            OSUtils.createStorageLocations();
            System.setProperty("java.net.preferIPv4Stack", "true");
            if (Settings.getSettings().getUseSystemProxy().booleanValue()) {
                System.setProperty("java.net.useSystemProxies", "true");
            }
            if (new File(Settings.getSettings().getInstallPath(), "FTBLauncherLog.txt").exists()) {
                new File(Settings.getSettings().getInstallPath(), "FTBLauncherLog.txt").delete();
            }
            if (new File(Settings.getSettings().getInstallPath(), "MinecraftLog.txt").exists()) {
                new File(Settings.getSettings().getInstallPath(), "MinecraftLog.txt").delete();
            }
            Logger.addListener(new StdOutLogger());
            System.setOut(new OutputOverride((OutputStream)System.out, LogLevel.INFO));
            System.setErr(new OutputOverride((OutputStream)System.err, LogLevel.ERROR));
            try {
                Logger.addListener(new LogWriter(new File(Settings.getSettings().getInstallPath(), "FTBLauncherLog.txt"), LogSource.LAUNCHER));
                Logger.addListener(new LogWriter(new File(Settings.getSettings().getInstallPath(), "MinecraftLog.txt"), LogSource.EXTERNAL));
            }
            catch (IOException e1) {
                if (noConfig) break block11;
                Logger.logError("Could not create LogWriters. Check your FTB installation location write access", e1);
            }
        }
        URL mf = LaunchFrame.class.getResource("/buildproperties.properties");
        int beta = 9999999;
        String mfStr = "";
        try {
            Properties props = new Properties();
            props.load(mf.openStream());
            mfStr = props.getProperty("LauncherJenkins");
            if (!mfStr.equals("${LauncherJenkins}")) {
                beta = Integer.parseInt(mfStr);
            }
            Logger.logDebug("FTB Launcher CI Build #: " + beta + ", Git SHA: " + props.getProperty("Git-SHA"));
        }
        catch (Exception e) {
            Logger.logError("Error getting beta information, assuming beta channel not usable!", e);
            beta = 9999999;
        }
        final int beta_ = beta;
        AnalyticsConfigData.setUserAgent("Java/" + System.getProperty("java.version") + " (" + System.getProperty("os.name") + "; " + System.getProperty("os.arch") + ")");
        tracker = new JGoogleAnalyticsTracker(AnalyticsConfigData, JGoogleAnalyticsTracker.GoogleAnalyticsVersion.V_4_7_2);
        tracker.setEnabled(true);
        TrackerUtils.sendPageView("net/ftb/gui/LaunchFrame.java", "Launcher Start v1.4.3 - by greg0ree." + beta);
        if (!new File(OSUtils.getDynamicStorageLocation(), "FTBOSSent1.4.3 - by greg0ree." + beta + ".txt").exists()) {
            TrackerUtils.sendPageView("net/ftb/gui/LaunchFrame.java", "Launcher 1.4.3 - by greg0ree." + beta + " OS " + OSUtils.getOSString());
            try {
                new File(OSUtils.getDynamicStorageLocation(), "FTBOSSent1.4.3 - by greg0ree.txt").createNewFile();
            }
            catch (IOException e) {
                Logger.logError("Error creating os cache text file");
            }
        }
        LaunchFrameHelpers.printInfo();
        DownloadUtils thread = new DownloadUtils();
        thread.start();
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                JavaInfo java;
                int result;
                StyleUtil.loadUiStyles();
                try {
                    for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                        if (!"Nimbus".equals(info.getName())) continue;
                        UIManager.setLookAndFeel(info.getClassName());
                        break;
                    }
                }
                catch (Exception e) {
                    try {
                        UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
                    }
                    catch (Exception e1) {
                        // empty catch block
                    }
                }
                loader = new LoadingDialog();
                loader.setModal(false);
                loader.setVisible(true);
                I18N.setupLocale();
                I18N.setLocale(Settings.getSettings().getLocale());
                if (noConfig) {
                    FirstRunDialog firstRunDialog = new FirstRunDialog();
                    firstRunDialog.setVisible(true);
                }
                LoadingDialog.setProgress(120);
                File installDir = new File(Settings.getSettings().getInstallPath());
                if (!installDir.exists()) {
                    installDir.mkdirs();
                }
                CheckInstallPath checkResult = new CheckInstallPath(Settings.getSettings().getInstallPath(), true);
                if ((checkResult.action == CheckInstallPath.Action.BLOCK || checkResult.action == CheckInstallPath.Action.WARN) && (result = ErrorUtils.tossOKIgnoreDialog(checkResult.localizedMessage, checkResult.action == CheckInstallPath.Action.BLOCK ? 0 : 2)) != 0 && result != -1 && checkResult.setting != null) {
                    Settings.getSettings().setBoolean(checkResult.setting, true);
                    Settings.getSettings().save();
                }
                if (!OSUtils.is64BitOS()) {
                    LaunchFrameHelpers.tossNag("launcher_32OS", I18N.getLocaleString("WARN_32BIT_OS"));
                }
                if (OSUtils.is64BitOS() && !Settings.getSettings().getCurrentJava().is64bits) {
                    LaunchFrameHelpers.tossNag("launcher_32java", I18N.getLocaleString("WARN_32BIT_JAVA"));
                }
                if ((java = Settings.getSettings().getCurrentJava()).getMajor() < 1 || java.getMajor() == 1 && java.getMinor() < 7) {
                    LaunchFrameHelpers.tossNag("launcher_java6", I18N.getLocaleString("WARN_JAVA6"));
                }
                LoadingDialog.setProgress(130);
                userManager = new UserManager(new File(OSUtils.getCacheStorageLocation(), "logindata"), new File(OSUtils.getDynamicStorageLocation(), "logindata"));
                LoadingDialog.setProgress(140);
                if (Settings.getSettings().getConsoleActive()) {
                    con = new LauncherConsole();
                    con.setVisible(true);
                    Logger.addListener(con);
                    con.scrollToBottom();
                }
                LaunchFrameHelpers.googleAnalytics();
                LoadingDialog.setProgress(160);
                AppUtils.waitForLock(i18nLoaded);
                LaunchFrame frame = new LaunchFrame(2);
                instance = frame;
                if (SystemTray.isSupported()) {
                    LaunchFrame.setUpSystemTray();
                } else {
                    Logger.logWarn("System Tray not supported");
                }
                AuthlibDLWorker authworker = new AuthlibDLWorker(OSUtils.getDynamicStorageLocation() + File.separator + "authlib" + File.separator, "1.5.13"){

                    @Override
                    protected void done() {
                        LaunchFrame.getInstance().getLaunch().setEnabled(true);
                    }
                };
                authworker.execute();
                LoadingDialog.setProgress(170);
                Thread.setDefaultUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

                    @Override
                    public void uncaughtException(Thread t, Throwable e) {
                        Logger.logError("Unhandled exception in " + t.toString(), e);
                    }
                });
                instance.setVisible(true);
                instance.toBack();
                instance.eventBus.register(frame.thirdPartyPane);
                instance.eventBus.register(frame.modPacksPane);
                instance.eventBus.register(this);
                ModPack.loadXml(LaunchFrame.getXmls());
                Map.addListener(frame.mapsPane);
                TexturePack.addListener(frame.tpPane);
                UpdateChecker updateChecker = new UpdateChecker(10403, minUsable, beta_){

                    @Override
                    protected void done() {
                        try {
                            if (((Boolean)this.get()).booleanValue()) {
                                LauncherUpdateDialog p = new LauncherUpdateDialog(this, minUsable);
                                p.setVisible(true);
                            }
                        }
                        catch (InterruptedException e) {
                        }
                        catch (ExecutionException executionException) {
                            // empty catch block
                        }
                    }
                };
                updateChecker.execute();
                LoadingDialog.setProgress(180);
            }
        });
    }

    public LaunchFrame(int tab) {
        this.setFont(new Font("a_FuturaOrto", 0, 12));
        this.setResizable(false);
        this.setTitle("Feed The Beast Launcher v1.4.3 - by greg0ree");
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("/image/logo_ftb.png")));
        panel = new JPanel();
        this.setDefaultCloseOperation(3);
        if (OSUtils.getCurrentOS() == OSUtils.OS.WINDOWS) {
            this.setBounds(100, 100, 842, 480);
        } else {
            this.setBounds(100, 100, 850, 480);
        }
        panel.setBounds(0, 0, 850, 480);
        panel.setLayout(null);
        this.footer.setBounds(0, 380, 850, 100);
        this.footer.setLayout(null);
        this.footer.setBackground(LauncherStyle.getCurrentStyle().footerColor);
        this.tabbedPane.setBounds(0, 0, 850, 380);
        panel.add(this.tabbedPane);
        panel.add(this.footer);
        this.setContentPane(panel);
        this.footerLogo.setCursor(Cursor.getPredefinedCursor(12));
        this.footerLogo.setBounds(20, 20, 42, 42);
        this.footerLogo.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                OSUtils.browse("http://www.feed-the-beast.com");
            }
        });
        this.footerCreeper.setCursor(Cursor.getPredefinedCursor(12));
        this.footerCreeper.setBounds(72, 20, 132, 42);
        this.footerCreeper.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                OSUtils.browse("http://greg0ree-ftb.blogspot.ca/");
            }
        });
        LaunchFrame.dropdown_[0] = I18N.getLocaleString("PROFILE_SELECT");
        LaunchFrame.dropdown_[1] = I18N.getLocaleString("PROFILE_CREATE");
        ArrayList<String> var = UserManager.getNames();
        String[] dropdown = ObjectUtils.concatenateArrays(dropdown_, new String[][]{var.toArray(new String[var.size()])});
        users = new JComboBox<String>(dropdown);
        if (Settings.getSettings().getLastUser() != null) {
            for (int i = 0; i < dropdown.length; ++i) {
                if (!dropdown[i].equalsIgnoreCase(Settings.getSettings().getLastUser())) continue;
                users.setSelectedIndex(i);
            }
        }
        this.donate.setText(I18N.getLocaleString("DONATE_BUTTON"));
        this.donate.setBounds(390, 20, 80, 30);
        this.donate.setEnabled(false);
        this.donate.setToolTipText("Coming Soon...");
        this.donate.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
            }
        });
        users.setBounds(550, 20, 150, 30);
        users.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (users.getSelectedIndex() == 1) {
                    ProfileAdderDialog p = new ProfileAdderDialog(LaunchFrame.getInstance(), true);
                    users.setSelectedIndex(0);
                    p.setVisible(true);
                }
                LaunchFrame.this.edit.setEnabled(users.getSelectedIndex() > 1);
            }
        });
        this.edit.setText(I18N.getLocaleString("EDIT_BUTTON"));
        this.edit.setBounds(480, 20, 60, 30);
        this.edit.setVisible(true);
        this.edit.setEnabled(users.getSelectedIndex() > 1);
        this.edit.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (users.getSelectedIndex() > 1) {
                    ProfileEditorDialog p = new ProfileEditorDialog(LaunchFrame.getInstance(), (String)users.getSelectedItem(), true);
                    users.setSelectedIndex(0);
                    p.setVisible(true);
                }
                LaunchFrame.this.edit.setEnabled(users.getSelectedIndex() > 1);
            }
        });
        this.launch.setText(I18N.getLocaleString("LAUNCH_BUTTON"));
        this.launch.setEnabled(false);
        this.launch.setBounds(711, 20, 100, 30);
        this.launch.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                LaunchFrame.this.doLaunch();
            }
        });
        this.serverbutton.setBounds(480, 20, 330, 30);
        this.serverbutton.setText(I18N.getLocaleString("DOWNLOAD_SERVER_PACK"));
        this.serverbutton.setVisible(false);
        this.serverbutton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                if (!ModPack.getSelectedPack().getServerUrl().isEmpty() && users.getSelectedIndex() > 1 && LaunchFrame.this.modPacksPane.packPanels.size() > 0) {
                    String version;
                    String string = version = Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") || Settings.getSettings().getPackVer().equalsIgnoreCase("newest version") ? ModPack.getSelectedPack().getVersion().replace(".", "_") : Settings.getSettings().getPackVer().replace(".", "_");
                    if (ModPack.getSelectedPack().isPrivatePack()) {
                        OSUtils.browse(DownloadUtils.getCreeperhostLink("privatepacks/" + ModPack.getSelectedPack().getDir() + "/" + version + "/" + ModPack.getSelectedPack().getServerUrl()));
                    } else {
                        OSUtils.browse(DownloadUtils.getCreeperhostLink("modpacks/" + ModPack.getSelectedPack().getDir() + "/" + version + "/" + ModPack.getSelectedPack().getServerUrl()));
                    }
                    TrackerUtils.sendPageView(ModPack.getSelectedPack().getName() + " Server Download", ModPack.getSelectedPack().getName());
                }
            }
        });
        this.mapInstall.setBounds(650, 20, 160, 30);
        this.mapInstall.setText(I18N.getLocaleString("INSTALL_MAP"));
        this.mapInstall.setVisible(false);
        this.mapInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                MapUtils cfr_ignored_0 = LaunchFrame.this.mapsPane;
                if (MapUtils.mapPanels.size() > 0 && LaunchFrame.getSelectedMapIndex() >= 0) {
                    MapManager man = new MapManager(new JFrame(), (Boolean)true);
                    man.setVisible(true);
                    MapManager.cleanUp();
                }
            }
        });
        mapInstallLocation = new JComboBox();
        mapInstallLocation.setBounds(480, 20, 160, 30);
        mapInstallLocation.setToolTipText("Install to...");
        mapInstallLocation.setVisible(false);
        this.serverMap.setBounds(480, 20, 330, 30);
        this.serverMap.setText(I18N.getLocaleString("DOWNLOAD_MAP_SERVER"));
        this.serverMap.setVisible(false);
        this.serverMap.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent event) {
                MapUtils cfr_ignored_0 = LaunchFrame.this.mapsPane;
                if (MapUtils.mapPanels.size() > 0 && LaunchFrame.getSelectedMapIndex() >= 0) {
                    OSUtils.browse(DownloadUtils.getCreeperhostLink("maps%5E" + Map.getMap(LaunchFrame.getSelectedMapIndex()).getMapName() + "%5E" + Map.getMap(LaunchFrame.getSelectedMapIndex()).getVersion() + "%5E" + Map.getMap(LaunchFrame.getSelectedMapIndex()).getUrl()));
                }
            }
        });
        this.tpInstall.setBounds(650, 20, 160, 30);
        this.tpInstall.setText(I18N.getLocaleString("INSTALL_TEXTUREPACK"));
        this.tpInstall.setVisible(false);
        this.tpInstall.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                TexturepackPane cfr_ignored_0 = LaunchFrame.this.tpPane;
                if (TexturepackPane.texturePackPanels.size() > 0 && LaunchFrame.getSelectedTexturePackIndex() >= 0) {
                    TextureManager man = new TextureManager(new JFrame(), (Boolean)true);
                    man.setVisible(true);
                }
            }
        });
        tpInstallLocation = new JComboBox();
        tpInstallLocation.setBounds(480, 20, 160, 30);
        tpInstallLocation.setToolTipText("Install to...");
        tpInstallLocation.setVisible(false);
        this.tpInstallLocLbl.setText("Install to...");
        this.tpInstallLocLbl.setBounds(480, 20, 80, 30);
        this.tpInstallLocLbl.setVisible(false);
        this.footer.add(this.edit);
        this.footer.add(users);
        this.footer.add(this.footerLogo);
        this.footer.add(this.footerCreeper);
        this.footer.add(this.launch);
        this.footer.add(this.donate);
        this.footer.add(this.serverbutton);
        this.footer.add(this.mapInstall);
        this.footer.add(mapInstallLocation);
        this.footer.add(this.serverMap);
        this.footer.add(this.tpInstall);
        this.footer.add(tpInstallLocation);
        this.newsPane = new NewsPane();
        this.modPacksPane = new FTBPacksPane();
        this.thirdPartyPane = new ThirdPartyPane();
        this.mapsPane = new MapUtils();
        this.tpPane = new TexturepackPane();
        this.optionsPane = new OptionsPane(Settings.getSettings());
        this.getRootPane().setDefaultButton(this.launch);
        this.updateLocale();
        this.tabbedPane.add((Component)this.newsPane, 0);
        this.tabbedPane.add((Component)this.optionsPane, 1);
        this.tabbedPane.add((Component)this.modPacksPane, 2);
        this.tabbedPane.add((Component)this.thirdPartyPane, 3);
        this.tabbedPane.add((Component)this.tpPane, 4);
        this.setNewsIcon();
        try {
            this.tabbedPane.setIconAt(1, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/options.png")));
            this.tabbedPane.setIconAt(2, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/ftbpacks.png")));
            this.tabbedPane.setIconAt(3, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/thirdpartypacks.png")));
            this.tabbedPane.setIconAt(4, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/mapstextures.png")));
        }
        catch (Exception e1) {
            Logger.logError("error changing colors", e1);
        }
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent event) {
                if (LaunchFrame.this.tabbedPane.getSelectedComponent() instanceof ILauncherPane) {
                    ((ILauncherPane)((Object)LaunchFrame.this.tabbedPane.getSelectedComponent())).onVisible();
                    currentPane = Panes.values()[LaunchFrame.this.tabbedPane.getSelectedIndex()];
                    LaunchFrame.this.updateFooter();
                }
            }
        });
        this.tabbedPane.setSelectedIndex(tab);
    }

    public static void checkDoneLoading() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (FTBPacksPane.getInstance().loaded) {
                    LoadingDialog.setProgress(190);
                    if (MapUtils.loaded) {
                        LoadingDialog.setProgress(200);
                        if (TexturepackPane.loaded) {
                            loader.setVisible(false);
                            instance.setVisible(true);
                            instance.toFront();
                            Benchmark.logBenchAs("main", "Launcher Startup");
                        }
                    }
                }
            }
        });
    }

    public void setNewsIcon() {
        UnreadNewsWorker unreadNews = new UnreadNewsWorker(){

            @Override
            protected void done() {
                try {
                    int i = (Integer)this.get();
                    if (i > 0 && i < 100) {
                        ImageAndTextIcon iti = new ImageAndTextIcon(this.getClass().getResource("/image/tabs/news_unread_" + Integer.toString(i).length() + ".png"), Integer.toString(i));
                        iti.setImage(LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/news_unread_" + Integer.toString(i).length() + ".png")).getImage());
                        LaunchFrame.getInstance().tabbedPane.setIconAt(0, iti);
                    } else {
                        LaunchFrame.getInstance().tabbedPane.setIconAt(0, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/news.png")));
                    }
                }
                catch (InterruptedException e) {
                }
                catch (ExecutionException executionException) {
                    // empty catch block
                }
            }
        };
        unreadNews.execute();
    }

    private void doLogin(final String username, String password, String mojangData) {
        if (ModPack.getSelectedPack().getDisclaimer() != null && !ModPack.getSelectedPack().getDisclaimer().isEmpty()) {
            ErrorUtils.tossError(ModPack.getSelectedPack().getDisclaimer());
        }
        if ((mojangData == null || mojangData.isEmpty()) && password.isEmpty()) {
            PasswordDialog p = new PasswordDialog(this, true);
            p.setVisible(true);
            if (tempPass.isEmpty()) {
                this.enableObjects();
                return;
            }
            password = tempPass;
        }
        Logger.logInfo("Logging in...");
        this.tabbedPane.setEnabledAt(0, false);
        this.tabbedPane.setIconAt(0, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/news.png")));
        this.tabbedPane.setEnabledAt(1, false);
        this.tabbedPane.setEnabledAt(2, false);
        this.tabbedPane.setEnabledAt(3, false);
        this.tabbedPane.setEnabledAt(4, false);
        this.tabbedPane.getSelectedComponent().setEnabled(false);
        this.launch.setEnabled(false);
        users.setEnabled(false);
        this.edit.setEnabled(false);
        this.serverbutton.setEnabled(false);
        this.mapInstall.setEnabled(false);
        mapInstallLocation.setEnabled(false);
        this.serverMap.setEnabled(false);
        this.tpInstall.setEnabled(false);
        tpInstallLocation.setEnabled(false);
        LoginWorker loginWorker = new LoginWorker(username, password, mojangData){

            @Override
            public void done() {
                String responseStr;
                try {
                    responseStr = (String)this.get();
                }
                catch (InterruptedException err) {
                    Logger.logError("User cancelled login process", err);
                    LaunchFrame.this.enableObjects();
                    return;
                }
                catch (ExecutionException err) {
                    if (err.getCause() instanceof IOException) {
                        Logger.logError("Error while logging in", err);
                        PlayOfflineDialog d = new PlayOfflineDialog("mcDown", username, UserManager.getUUID(username), this.getResp());
                        d.setVisible(true);
                    }
                    LaunchFrame.this.enableObjects();
                    return;
                }
                LaunchFrame.this.RESPONSE = this.getResp();
                Logger.logDebug("responseStr: " + responseStr);
                String uuid = UserManager.getUUID(username);
                if (responseStr.equals("good")) {
                    Logger.logInfo("Login complete.");
                    try {
                        userManager.write();
                        Logger.logDebug("user data saved");
                    }
                    catch (IOException e) {
                        Logger.logError("logindata saving failed!");
                    }
                    LaunchFrame.this.runGameUpdater();
                } else if (uuid != null && !uuid.isEmpty() && LaunchFrame.this.RESPONSE != null && responseStr.equals("offline")) {
                    Logger.logDebug("Asking user for offline mode");
                    PlayOfflineDialog d = new PlayOfflineDialog("mcDown", username, uuid, LaunchFrame.this.RESPONSE);
                    d.setVisible(true);
                } else {
                    Logger.logDebug("Bad responseStr, not starting MC");
                    LaunchFrame.this.enableObjects();
                    return;
                }
                LaunchFrame.this.enableObjects();
            }
        };
        loginWorker.execute();
    }

    private Boolean checkVersion(File verFile, ModPack pack) {
        String onlineVersion;
        String storedVersion = pack.getStoredVersion(verFile);
        String string = onlineVersion = Settings.getSettings().getPackVer().equalsIgnoreCase("recommended version") || Settings.getSettings().getPackVer().equalsIgnoreCase("newest version") ? pack.getVersion() : Settings.getSettings().getPackVer();
        if (storedVersion.isEmpty()) {
            allowVersionChange = true;
            return true;
        }
        if (Integer.parseInt(storedVersion.replace(".", "")) != Integer.parseInt(onlineVersion.replace(".", ""))) {
            ModPackVersionChangeDialog verDialog = new ModPackVersionChangeDialog(this, true, storedVersion, onlineVersion);
            verDialog.setVisible(true);
        }
        return allowVersionChange & !storedVersion.equals(onlineVersion);
    }

    private void runGameUpdater() {
        String installPath = Settings.getSettings().getInstallPath();
        ModPack pack = ModPack.getSelectedPack();
        Logger.logDebug("ForceUpdate: " + Settings.getSettings().isForceUpdateEnabled());
        Logger.logDebug("installPath: " + installPath);
        Logger.logDebug("pack dir: " + pack.getDir());
        Logger.logDebug("pack check path: " + pack.getDir() + File.separator + "version");
        File verFile = new File(installPath, pack.getDir() + File.separator + "version");
        if (Settings.getSettings().isForceUpdateEnabled() && verFile.exists()) {
            verFile.delete();
            Logger.logDebug("Pack found and delete attempted");
        }
        if (Settings.getSettings().isForceUpdateEnabled() || !verFile.exists() || this.checkVersion(verFile, pack).booleanValue()) {
            if (doVersionBackup) {
                try {
                    File destination = new File(OSUtils.getCacheStorageLocation(), "backups" + File.separator + pack.getDir() + File.separator + "config_backup");
                    if (destination.exists()) {
                        FileUtils.delete(destination);
                    }
                    FileUtils.copyFolder(new File(Settings.getSettings().getInstallPath(), pack.getDir() + File.separator + "minecraft" + File.separator + "config"), destination);
                }
                catch (IOException e) {
                    Logger.logError("Error while doing backups", e);
                }
            }
            if (!this.initializeMods()) {
                Logger.logDebug("initializeMods: Failed to Init mods! Aborting to menu.");
                this.enableObjects();
                return;
            }
        }
        try {
            TextureManager.updateTextures();
        }
        catch (Exception e1) {
            // empty catch block
        }
        boolean isLegacy = true;
        if (pack.getMcVersion().startsWith("1.6") || pack.getMcVersion().startsWith("1.7") || pack.getMcVersion().startsWith("1.8") || pack.getMcVersion().startsWith("14w")) {
            isLegacy = false;
        }
        MCInstaller.setupNewStyle(installPath, pack, isLegacy, this.RESPONSE);
    }

    public void saveSettings() {
        Settings.getSettings().setLastUser(String.valueOf(users.getSelectedItem()));
        LaunchFrame.instance.optionsPane.saveSettingsInto(Settings.getSettings());
    }

    public static void writeUsers(String user) {
        try {
            userManager.write();
        }
        catch (IOException e) {
            // empty catch block
        }
        ArrayList<String> var = UserManager.getNames();
        String[] usernames = ObjectUtils.concatenateArrays(dropdown_, new String[][]{var.toArray(new String[var.size()])});
        users.removeAllItems();
        for (int i = 0; i < usernames.length; ++i) {
            users.addItem(usernames[i]);
            if (!usernames[i].equals(user)) continue;
            users.setSelectedIndex(i);
        }
    }

    public static void updateTpInstallLocs(List<String> locations) {
        tpInstallLocation.removeAllItems();
        for (String location : locations) {
            if (location == null || location.isEmpty()) continue;
            tpInstallLocation.addItem(ModPack.getPack(location.trim()).getName());
        }
        tpInstallLocation.setSelectedItem(ModPack.getSelectedPack(true).getName());
    }

    public static void updateMapInstallLocs(String[] locations) {
        mapInstallLocation.removeAllItems();
        for (String location : locations) {
            if (location == null || location.isEmpty()) continue;
            mapInstallLocation.addItem(ModPack.getPack(location.trim()).getName());
        }
    }

    public static int getSelectedMapIndex() {
        LaunchFrame launchFrame = instance;
        return launchFrame.mapsPane.getSelectedMapIndex();
    }

    public static int getSelectedTexturePackIndex() {
        LaunchFrame launchFrame = instance;
        return launchFrame.tpPane.getSelectedTexturePackIndex();
    }

    public static int getSelectedMapInstallIndex() {
        return mapInstallLocation.getSelectedIndex();
    }

    public static int getSelectedTPInstallIndex() {
        return tpInstallLocation.getSelectedIndex();
    }

    private void enableObjects() {
        this.tabbedPane.setEnabledAt(0, true);
        this.setNewsIcon();
        this.tabbedPane.setEnabledAt(1, true);
        this.tabbedPane.setEnabledAt(2, true);
        this.tabbedPane.setEnabledAt(3, true);
        this.tabbedPane.setEnabledAt(4, true);
        this.tabbedPane.getSelectedComponent().setEnabled(true);
        this.updateFooter();
        this.mapInstall.setEnabled(true);
        mapInstallLocation.setEnabled(true);
        this.serverMap.setEnabled(true);
        this.tpInstall.setEnabled(true);
        this.launch.setEnabled(true);
        users.setEnabled(true);
        this.serverbutton.setEnabled(true);
        tpInstallLocation.setEnabled(true);
        TextureManager.updating = false;
    }

    @Subscribe
    private void handleEnableObjectsEvent(EnableObjectsEvent e) {
        this.enableObjects();
    }

    private boolean initializeMods() {
        Logger.logDebug("pack dir...");
        Logger.logInfo(ModPack.getSelectedPack().getDir());
        ModManager man = new ModManager(new JFrame(), (Boolean)true);
        man.setVisible(true);
        while (man == null) {
        }
        while (true) {
            if (ModManager.worker.isDone()) break;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException ignored) {}
        }
        if (ModManager.erroneous) {
            return false;
        }
        try {
            MCInstaller.installMods(ModPack.getSelectedPack().getDir());
            man.cleanUp();
        }
        catch (IOException e) {
            Logger.logDebug("Exception: ", e);
        }
        return true;
    }

    public void disableMainButtons() {
        this.serverbutton.setVisible(false);
        this.launch.setVisible(false);
        this.edit.setVisible(false);
        users.setVisible(false);
    }

    public void disableMapButtons() {
        this.mapInstall.setVisible(false);
        mapInstallLocation.setVisible(false);
        this.serverMap.setVisible(false);
    }

    public void disableTextureButtons() {
        this.tpInstall.setVisible(false);
        tpInstallLocation.setVisible(false);
    }

    public void updateFooter() {
        switch (currentPane) {
            case TEXTURE: {
                if (this.tpEnabled) {
                    this.tpInstall.setVisible(true);
                    tpInstallLocation.setVisible(true);
                    this.disableMainButtons();
                    this.disableMapButtons();
                    break;
                }
                boolean result = MapUtils.type.equals("Server");
                this.mapInstall.setVisible(!result);
                mapInstallLocation.setVisible(!result);
                this.serverMap.setVisible(result);
                this.disableMainButtons();
                this.disableTextureButtons();
                break;
            }
            default: {
                this.launch.setVisible(true);
                this.edit.setEnabled(users.getSelectedIndex() > 1);
                this.edit.setVisible(true);
                users.setVisible(true);
                this.serverbutton.setVisible(false);
                this.disableMapButtons();
                this.disableTextureButtons();
            }
        }
    }

    public void updateLocale() {
        if (I18N.currentLocale == I18N.Locale.deDE) {
            this.edit.setBounds(420, 20, 120, 30);
            this.donate.setBounds(330, 20, 80, 30);
            this.mapInstall.setBounds(620, 20, 190, 30);
            mapInstallLocation.setBounds(420, 20, 190, 30);
            this.serverbutton.setBounds(420, 20, 390, 30);
            tpInstallLocation.setBounds(420, 20, 190, 30);
            this.tpInstall.setBounds(620, 20, 190, 30);
        } else {
            this.edit.setBounds(480, 20, 60, 30);
            this.donate.setBounds(390, 20, 80, 30);
            this.mapInstall.setBounds(650, 20, 160, 30);
            mapInstallLocation.setBounds(480, 20, 160, 30);
            this.serverbutton.setBounds(480, 20, 330, 30);
            tpInstallLocation.setBounds(480, 20, 160, 30);
            this.tpInstall.setBounds(650, 20, 160, 30);
        }
        this.launch.setText(I18N.getLocaleString("LAUNCH_BUTTON"));
        this.edit.setText(I18N.getLocaleString("EDIT_BUTTON"));
        this.serverbutton.setText(I18N.getLocaleString("DOWNLOAD_SERVER_PACK"));
        this.mapInstall.setText(I18N.getLocaleString("INSTALL_MAP"));
        this.serverMap.setText(I18N.getLocaleString("DOWNLOAD_MAP_SERVER"));
        this.tpInstall.setText(I18N.getLocaleString("INSTALL_TEXTUREPACK"));
        this.donate.setText(I18N.getLocaleString("DONATE_BUTTON"));
        LaunchFrame.dropdown_[0] = I18N.getLocaleString("PROFILE_SELECT");
        LaunchFrame.dropdown_[1] = I18N.getLocaleString("PROFILE_CREATE");
        this.optionsPane.updateLocale();
        this.modPacksPane.updateLocale();
        this.thirdPartyPane.updateLocale();
        this.mapsPane.updateLocale();
        this.tpPane.updateLocale();
        if (trayMenu != null) {
            trayMenu.updateLocale();
        }
    }

    private static ArrayList<String> getXmls() {
        ArrayList<String> s = Settings.getSettings().getPrivatePacks();
        if (s == null) {
            s = new ArrayList();
        }
        for (int i = 0; i < s.size(); ++i) {
            if (s.get(i).isEmpty()) {
                s.remove(i);
                --i;
                continue;
            }
            String temp = s.get(i);
            if (temp.endsWith(".xml")) continue;
            s.remove(i);
            s.add(i, temp + ".xml");
        }
        s.add(0, "modpacks.xml");
        s.add(1, "thirdparty.xml");
        return s;
    }

    public void doLaunch() {
        JavaInfo java = Settings.getSettings().getCurrentJava();
        int[] minSup = ModPack.getSelectedPack().getMinJRE();
        if (ModPack.getSelectedPack().getMinLaunchSpec() <= 10403) {
            if (users.getSelectedIndex() > 1 && ModPack.getSelectedPack() != null) {
                if (minSup.length >= 2 && minSup[0] <= java.getMajor() && minSup[1] <= java.getMinor()) {
                    Settings.getSettings().setLastFTBPack(ModPack.getSelectedPack(true).getDir());
                    Settings.getSettings().setLastThirdPartyPack(ModPack.getSelectedPack(false).getDir());
                    this.saveSettings();
                    this.doLogin(UserManager.getUsername(users.getSelectedItem().toString()), UserManager.getPassword(users.getSelectedItem().toString()), UserManager.getMojangData(users.getSelectedItem().toString()));
                } else {
                    ErrorUtils.tossError("You must use at least java " + minSup[0] + "." + minSup[1] + " to play this pack! Please go to Options to get a link or Advanced Options enter a path.", java.toString());
                }
            } else if (users.getSelectedIndex() <= 1) {
                ErrorUtils.tossError("Please select a profile!");
            }
        } else {
            ErrorUtils.tossError("Please update your launcher in order to launch this pack! This can be done by restarting your launcher, an update dialog will pop up.");
        }
    }

    public void swapTabs(boolean toMaps) {
        if (toMaps) {
            this.tabbedPane.remove(4);
            this.tabbedPane.add((Component)this.mapsPane, 4);
            this.tabbedPane.setIconAt(4, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/mapstextures.png")));
            this.tabbedPane.setSelectedIndex(4);
            this.tpEnabled = false;
            this.updateFooter();
        } else {
            this.tabbedPane.remove(4);
            this.tabbedPane.add((Component)this.tpPane, 4);
            this.tabbedPane.setIconAt(4, LauncherStyle.getCurrentStyle().filterHeaderIcon(this.getClass().getResource("/image/tabs/mapstextures.png")));
            this.tabbedPane.setSelectedIndex(4);
            this.tpEnabled = true;
            this.updateFooter();
        }
    }

    private static void setUpSystemTray() {
        trayMenu = new TrayMenu();
        SystemTray tray = SystemTray.getSystemTray();
        TrayIcon trayIcon = new TrayIcon(Toolkit.getDefaultToolkit().getImage(instance.getClass().getResource("/image/logo_ftb.png")));
        trayIcon.setPopupMenu(trayMenu);
        trayIcon.setToolTip("Feed The Beast Launcher");
        trayIcon.setImageAutoSize(true);
        try {
            tray.add(trayIcon);
        }
        catch (AWTException e) {
            e.printStackTrace();
        }
    }

    public JButton getLaunch() {
        return this.launch;
    }

    public JButton getEdit() {
        return this.edit;
    }

    public JButton getDonate() {
        return this.donate;
    }

    public JButton getServerbutton() {
        return this.serverbutton;
    }

    public JButton getMapInstall() {
        return this.mapInstall;
    }

    public JButton getServerMap() {
        return this.serverMap;
    }

    public JButton getTpInstall() {
        return this.tpInstall;
    }

    public static LaunchFrame getInstance() {
        return instance;
    }

    public static ProcessMonitor getProcMonitor() {
        return procMonitor;
    }

    public static void setProcMonitor(ProcessMonitor procMonitor) {
        LaunchFrame.procMonitor = procMonitor;
    }

    public EventBus getEventBus() {
        return this.eventBus;
    }

    static {
        dropdown_ = new String[]{"Select Profile", "Create Profile"};
        instance = null;
        minUsable = -1;
        noConfig = false;
        allowVersionChange = false;
        doVersionBackup = false;
        MCRunning = false;
        i18nLoaded = false;
        tempPass = "";
        currentPane = Panes.MODPACK;
        AnalyticsConfigData = new AnalyticsConfigData("UA-37330489-2");
    }

    public static enum Panes {
        NEWS,
        OPTIONS,
        MODPACK,
        THIRDPARTY,
        TEXTURE;

    }
}

